/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.advanced;

import java.util.ArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.SubGuiColorSelector;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailability;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.renderer.MarkRenderer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNPCMarks
extends GuiNPCInterface2
implements ICustomScrollListener {
    protected static final String[] marks = new String[]{"gui.none", "mark.question", "mark.exclamation", "mark.pointer", "mark.skull", "mark.cross", "mark.star"};
    protected final MarkData data;
    protected MarkData.Mark selectedMark;
    protected final MarkData dataDisplay;
    protected final EntityNPCInterface npcDisplay;
    protected GuiCustomScroll scroll;
    protected String selMark = "";
    public final GuiScreen parent;

    public GuiNPCMarks(EntityNPCInterface npc, GuiScreen gui) {
        super(npc);
        this.data = MarkData.get((EntityLivingBase)npc);
        this.parent = gui;
        this.npcDisplay = new EntityCustomNpc((World)this.field_146297_k.field_71441_e);
        NBTTagCompound nbtData = new NBTTagCompound();
        npc.func_70014_b(nbtData);
        this.npcDisplay.func_70037_a(nbtData);
        this.npcDisplay.display.setShowName(1);
        this.dataDisplay = MarkData.get((EntityLivingBase)this.npcDisplay);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (this.selectedMark == null) {
            return;
        }
        switch (button.getID()) {
            case 0: {
                this.selectedMark.type = button.getValue();
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.setSubGui(new SubGuiColorSelector(this.selectedMark.color, new SubGuiColorSelector.ColorCallback(){

                    @Override
                    public void color(int colorIn) {
                        if (GuiNPCMarks.this.selectedMark == null) {
                            return;
                        }
                        GuiNPCMarks.this.selectedMark.color = ((SubGuiColorSelector)GuiNPCMarks.this.subgui).color;
                        GuiNPCMarks.this.func_73866_w_();
                    }

                    @Override
                    public void preColor(int colorIn) {
                        if (GuiNPCMarks.this.selectedMark == null) {
                            return;
                        }
                        GuiNPCMarks.this.selectedMark.color = ((SubGuiColorSelector)GuiNPCMarks.this.subgui).color;
                        GuiNPCMarks.this.func_73866_w_();
                    }
                }));
                break;
            }
            case 2: {
                this.setSubGui(new SubGuiNpcAvailability(this.selectedMark.availability, this.parent));
                break;
            }
            case 3: {
                MarkData.Mark newark = (MarkData.Mark)this.data.addMark(this.selectedMark.type);
                newark.color = this.selectedMark.color;
                newark.rotate = this.selectedMark.rotate;
                newark.availability.load(this.selectedMark.availability.save(new NBTTagCompound()));
                this.selectedMark = newark;
                this.func_73866_w_();
                break;
            }
            case 4: {
                if (this.scroll.getSelect() < 0) {
                    return;
                }
                this.data.marks.remove(this.selectedMark);
                this.scroll.setSelect(-1);
                this.selMark = "";
                this.selectedMark = null;
                this.func_73866_w_();
                break;
            }
            case 5: {
                this.selectedMark.rotate = button.getValue() == 0;
                this.func_73866_w_();
                break;
            }
            case 6: {
                this.selectedMark.is3d = button.getValue() == 0;
                MarkRenderer.needReload = true;
                this.func_73866_w_();
            }
        }
    }

    @Override
    public void close() {
        this.save();
        CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        this.drawNpc((Entity)this.npcDisplay, 350, 150, 1.0f, 0, 0, 1);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        Gui.func_73734_a((int)(this.guiLeft + 319), (int)(this.guiTop + 30), (int)(this.guiLeft + 380), (int)(this.guiTop + 165), (int)-8355712);
        Gui.func_73734_a((int)(this.guiLeft + 320), (int)(this.guiTop + 31), (int)(this.guiLeft + 379), (int)(this.guiTop + 164), (int)-16777216);
        GlStateManager.func_179121_F();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> ds = new ArrayList<String>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        int i = 0;
        for (MarkData.Mark mark : this.data.marks) {
            String name = i + ": " + new TextComponentTranslation(marks[mark.type], new Object[0]).func_150254_d();
            ds.add(name);
            colors.add(mark.color);
            if (!this.selMark.isEmpty() && this.selMark.equals(name)) {
                this.selectedMark = mark;
            }
            ++i;
        }
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(130, 174);
        }
        this.scroll.setListNotSorted(ds);
        this.scroll.guiLeft = this.guiLeft + 5;
        this.scroll.guiTop = this.guiTop + 14;
        this.scroll.setColors(colors);
        if (this.selectedMark != null && !this.selMark.isEmpty()) {
            this.scroll.setSelected(this.selMark);
        }
        this.addScroll(this.scroll);
        if (this.selectedMark == null) {
            this.selectedMark = (MarkData.Mark)this.data.getNewMark();
        }
        GuiNpcButton button = new GuiButtonBiDirectional(0, this.guiLeft + 140, this.guiTop + 14, 120, 20, marks, this.selectedMark.getType());
        button.setHoverText("mark.hover.type", new Object[0]);
        this.addButton(button);
        StringBuilder color = new StringBuilder(Integer.toHexString(this.selectedMark.getColor()));
        while (color.length() < 6) {
            color.insert(0, "0");
        }
        button = new GuiNpcButton(1, this.guiLeft + 140, this.guiTop + 36, 120, 20, color.toString());
        button.setHoverText("color.hover", new Object[0]);
        button.setTextColor(this.selectedMark.getColor());
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 140, this.guiTop + 58, 120, 20, "availability.options");
        button.setHoverText("availability.hover", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, this.guiLeft + 5, this.guiTop + this.ySize - 9, 64, 20, "gui.add");
        button.field_146124_l = this.selectedMark.type > 0;
        button.setHoverText("mark.hover.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, this.guiLeft + 71, this.guiTop + this.ySize - 9, 64, 20, "gui.remove");
        button.field_146124_l = this.scroll.getSelect() >= 0;
        button.setHoverText("mark.hover.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(5, this.guiLeft + 140, this.guiTop + 80, 120, 20, new String[]{"movement.rotation", "ai.standing"}, this.selectedMark.rotate ? 0 : 1);
        button.setHoverText("mark.hover.rotate", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(6, this.guiLeft + 140, this.guiTop + 102, 120, 20, new String[]{"3D", "2D"}, this.selectedMark.is3d ? 0 : 1);
        button.setHoverText("mark.hover.is3d", new Object[0]);
        this.addButton(button);
        this.dataDisplay.marks.clear();
        MarkData.Mark mark = (MarkData.Mark)this.dataDisplay.addMark(this.selectedMark.type);
        mark.setColor(this.selectedMark.color);
        mark.setRotate(this.selectedMark.rotate);
        mark.set3D(this.selectedMark.is3d);
        mark.availability = new Availability();
        this.addLabel(new GuiNpcLabel(5, new TextComponentTranslation("advanced.marks", new Object[0]).func_150254_d() + ":", this.guiLeft + 5, this.guiTop + 4));
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void save() {
        Client.sendData(EnumPacketServer.MainmenuAdvancedMarkData, this.data.getNBT());
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int time, IGuiCustomScroll scroll) {
        if (this.selMark.equals(scroll.getSelected())) {
            return;
        }
        this.selMark = scroll.getSelected();
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }
}

